package gov.va.med.mhv.usermgmt.common.enums;

/**
 * Deactivation reason codes found in user_profile_deact_reason table 
 *
 */

public enum UserProfileDeactivationReasonEnumeration {
	MOP_UP("Mop Up", 0),
	DECEASED("Deceased", 1),
	USER_REQUEST("User Request", 2),
	MULTIPLE_MHV_ACCOUNTS_RESOLUTION("Multiple MHV Accounts Resolution", 3),
	CORRUPTED_DATA("Corrupted Data (resulting from VistA extract)", 4),
	PROVIDER_REQUEST("Provider Request", 5),
	MPI_STAFF_REQUEST("MPI Staff Request", 6),
	MPI_MERGE_REQUEST("MPI Merge Request", 7),
	MVI_STAFF_REQUEST("MVI Staff Request", 8),
	MVI_MERGE_REQUEST("MVI Merge Request", 9),
	ICN_MISMATCH("ICN Mismatch (do not reactivate)", 10),
	A31_ICN_MISMATCH("A31 possible ICN Mismatch (do not reactivate)", 11),
	HD_EMERGENCY_DEACTIVATION("HD Emergency Deactivation", 12),
	A43_ICN_MISMATCH("A43 possible ICN Mismatch due to patient having same ICN as another patient - (Do Not Reactivate)", 13),
	INACTIVE_ACCOUNT("Inactive Account", 14);
	
	private String description;
	private int value;
	
	UserProfileDeactivationReasonEnumeration(String desc, int val){
		description = desc;
		value = val;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}
}
